/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity.item;

import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ArrowButtonScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.button.ArrowButtonComponent;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemInfinityHammer
extends ItemInfinity {
    public static HashMap<Class<?>, Function<Entity, ItemStack>> HEADS = new HashMap();
    public static int POWER_CONSUMPTION = 10000;
    public static int FUEL_CONSUMPTION = 3;
    public static int DAMAGE = 10;
    public static float ATTACK_SPEED = -2.0f;
    public static String BEHEADING_NBT = "Beheading";

    public ItemInfinityHammer(CreativeModeTab group) {
        super("infinity_hammer", group, new Item.Properties().m_41487_(1), POWER_CONSUMPTION, FUEL_CONSUMPTION, true);
    }

    public static ItemStack createHead(String name) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42680_);
        stack.m_41784_().m_128359_("SkullOwner", name);
        return stack;
    }

    @Override
    public void addNbt(ItemStack stack, long power, int fuel, boolean special) {
        super.addNbt(stack, power, fuel, special);
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128405_(BEHEADING_NBT, 0);
        stack.m_41751_(nbt);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return Items.f_42388_.canApplyAtEnchantingTable(new ItemStack((ItemLike)Items.f_42388_), enchantment);
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    @Override
    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return false;
    }

    @Override
    public float m_8102_(ItemStack stack, BlockState state) {
        if (state.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        Material material = state.m_60767_();
        return material != Material.f_76300_ && material != Material.f_76302_ && !state.m_204336_(BlockTags.f_13035_) && material != Material.f_76285_ ? 1.0f : 1.5f;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        InfinityTier infinityTier = ItemInfinityHammer.getSelectedTier(stack);
        if (infinityTier.getRadius() > 1 && attacker instanceof Player) {
            AABB area = new AABB(target.m_20185_(), target.m_20186_(), target.m_20189_(), target.m_20185_(), target.m_20186_(), target.m_20189_()).m_82400_((double)infinityTier.getRadius());
            List mobs = attacker.m_20193_().m_45976_(Mob.class, new AABB(target.m_20185_(), target.m_20186_(), target.m_20189_(), target.m_20185_(), target.m_20186_(), target.m_20189_()).m_82400_((double)infinityTier.getRadius()));
            mobs.forEach(mobEntity -> {
                if (this.enoughFuel(stack)) {
                    mobEntity.m_6469_(DamageSource.m_19344_((Player)((Player)attacker)), (float)((double)DAMAGE + Math.pow(2.0, infinityTier.getRadius())) * 0.8f);
                    this.consumeFuel(stack);
                    if (mobEntity.m_21223_() <= 0.0f && attacker.m_20193_().f_46441_.m_188500_() <= (double)this.getCurrentBeheading(stack) * 0.15) {
                        ItemStack head = HEADS.getOrDefault(mobEntity.getClass(), entity -> ItemStack.f_41583_).apply((Entity)mobEntity);
                        Block.m_49840_((Level)attacker.f_19853_, (BlockPos)attacker.m_20183_(), (ItemStack)head);
                    }
                }
            });
            attacker.m_20193_().m_45976_(ItemEntity.class, area.m_82400_(1.0)).forEach(itemEntity -> {
                itemEntity.m_32061_();
                itemEntity.m_6021_((double)attacker.m_20183_().m_123341_(), (double)(attacker.m_20183_().m_123342_() + 1), (double)attacker.m_20183_().m_123343_());
            });
            attacker.m_20193_().m_45976_(ExperienceOrb.class, area.m_82400_(1.0)).forEach(entityXPOrb -> entityXPOrb.m_6021_((double)attacker.m_20183_().m_123341_(), (double)attacker.m_20183_().m_123342_(), (double)attacker.m_20183_().m_123343_()));
        }
        if (target.m_21223_() <= 0.0f && target instanceof Player) {
            Block.m_49840_((Level)attacker.f_19853_, (BlockPos)attacker.m_20183_(), (ItemStack)ItemInfinityHammer.createHead(target.m_5446_().getString()));
        }
        return true;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        InfinityTier infinityTier = ItemInfinityHammer.getSelectedTier(stack);
        Player player = context.m_43723_();
        if (infinityTier.getRadius() > 1) {
            Vec3[] all;
            Vec3 looking = player.m_20154_();
            for (Vec3 vector3d : all = new Vec3[]{looking, looking.m_82524_(0.22f), looking.m_82524_(-0.22f)}) {
                float f = (float)Mth.m_14136_((double)vector3d.f_82481_, (double)vector3d.f_82479_);
                int i = 0;
                while ((double)i < (double)infinityTier.getRadius() * 1.5 + 1.0) {
                    double d2 = 1.25 * (double)(i + 1);
                    int j = 1;
                    this.spawnFangs((LivingEntity)player, player.m_20185_() + (double)Mth.m_14089_((float)f) * d2, player.m_20189_() + (double)Mth.m_14031_((float)f) * d2, player.m_20186_() - 1.0, player.m_20186_() + 1.0, f, j);
                    this.consumeFuel(stack);
                    ++i;
                }
            }
            player.m_36335_().m_41524_((Item)this, 12);
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    private void spawnFangs(LivingEntity caster, double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = new BlockPos(x, maxY, z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = caster.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)caster.f_19853_, blockpos1, Direction.UP)) continue;
            if (!caster.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = caster.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)caster.f_19853_, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            caster.f_19853_.m_7967_((Entity)new EvokerFangs(caster.f_19853_, x, (double)blockpos.m_123342_() + d0, z, rotation, delay, caster));
        }
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
            entityLiving.m_21166_(EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public boolean m_8096_(BlockState blockIn) {
        return blockIn.m_60713_(Blocks.f_50033_);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ListMultimap multimap = MultimapBuilder.hashKeys().arrayListValues().build();
        if (slot == EquipmentSlot.MAINHAND) {
            InfinityTier infinityTier = (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityHammer.getPowerFromStack(stack)).getLeft());
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)DAMAGE + Math.pow(2.0, infinityTier.getRadius()), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)ATTACK_SPEED, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public int getCurrentBeheading(ItemStack stack) {
        return stack.m_41784_().m_128451_(BEHEADING_NBT);
    }

    public int getMaxBeheading(ItemStack stack) {
        InfinityTier infinityTier = (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityHammer.getPowerFromStack(stack)).getLeft());
        return Math.min(Math.max(0, infinityTier.getRadius() - 2), 3);
    }

    public void setBeheading(ItemStack stack, int level) {
        stack.m_41784_().m_128405_(BEHEADING_NBT, level);
    }

    @Override
    public void addTooltipDetails(BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        String level = "0";
        switch (this.getCurrentBeheading(stack)) {
            case 1: {
                level = "I";
                break;
            }
            case 2: {
                level = "II";
                break;
            }
            case 3: {
                level = "III";
            }
        }
        tooltip.add((Component)Component.m_237115_((String)"text.industrialforegoing.display.beheading").m_130946_(" " + level).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons(final Supplier<ItemStack> stack) {
        List<IFactory<? extends IScreenAddon>> factory = super.getScreenAddons(stack);
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(154, 52, 14, 14, FacingUtil.Sideness.RIGHT).setId(4))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new ArrowButtonScreenAddon((ArrowButtonComponent)new ArrowButtonComponent(54, 52, 14, 14, FacingUtil.Sideness.LEFT).setId(5))));
        factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new TextScreenAddon("", 72, 56, false){

            public String getText() {
                return ChatFormatting.DARK_GRAY + Component.m_237115_((String)"text.industrialforegoing.display.beheading").m_130946_(": ").m_130946_(ItemInfinityHammer.this.getCurrentBeheading((ItemStack)stack.get()) + "/" + ItemInfinityHammer.this.getMaxBeheading((ItemStack)stack.get())).getString();
            }
        }));
        return factory;
    }

    @Override
    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        super.handleButtonMessage(id, playerEntity, compound);
        ItemStack stack = playerEntity.m_21120_(InteractionHand.MAIN_HAND);
        int currentBeheading = this.getCurrentBeheading(stack);
        int maxBeheading = this.getMaxBeheading(stack);
        if (id == 5 && currentBeheading > 0) {
            this.setBeheading(stack, Math.max(currentBeheading - 1, 0));
        }
        if (id == 4 && currentBeheading < maxBeheading) {
            this.setBeheading(stack, Math.min(3, currentBeheading + 1));
        }
    }

    @Override
    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        new DissolutionChamberRecipe(ForgeRegistries.ITEMS.getKey((Object)this), new Ingredient.Value[]{new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_41959_)), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_42388_)), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_41959_)), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_42391_)), new Ingredient.ItemValue(new ItemStack((ItemLike)ModuleCore.RANGE_ADDONS[11].get())), new Ingredient.TagValue(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagValue(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagValue(IndustrialTags.Items.GEAR_GOLD)}, new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid().get(), 2000), 400, new ItemStack((ItemLike)this), FluidStack.EMPTY);
    }

    static {
        HEADS.put(WitherSkeleton.class, entity -> new ItemStack((ItemLike)Blocks.f_50312_));
        HEADS.put(Skeleton.class, entity -> new ItemStack((ItemLike)Blocks.f_50310_));
        HEADS.put(Zombie.class, entity -> new ItemStack((ItemLike)Blocks.f_50314_));
        HEADS.put(Creeper.class, entity -> new ItemStack((ItemLike)Blocks.f_50318_));
        HEADS.put(EnderDragon.class, entity -> new ItemStack((ItemLike)Blocks.f_50320_));
    }
}

